/*! jQuery JSON plugin 2.4.0 | code.google.com/p/jquery-json */
(function($){'use strict';var escape=/["\\\x00-\x1f\x7f-\x9f]/g,meta={'\b':'\\b','\t':'\\t','\n':'\\n','\f':'\\f','\r':'\\r','"':'\\"','\\':'\\\\'},hasOwn=Object.prototype.hasOwnProperty;$.toJSON=typeof JSON==='object'&&JSON.stringify?JSON.stringify:function(o){if(o===null){return'null';}
var pairs,k,name,val,type=$.type(o);if(type==='undefined'){return undefined;}
if(type==='number'||type==='boolean'){return String(o);}
if(type==='string'){return $.quoteString(o);}
if(typeof o.toJSON==='function'){return $.toJSON(o.toJSON());}
if(type==='date'){var month=o.getUTCMonth()+1,day=o.getUTCDate(),year=o.getUTCFullYear(),hours=o.getUTCHours(),minutes=o.getUTCMinutes(),seconds=o.getUTCSeconds(),milli=o.getUTCMilliseconds();if(month<10){month='0'+month;}
if(day<10){day='0'+day;}
if(hours<10){hours='0'+hours;}
if(minutes<10){minutes='0'+minutes;}
if(seconds<10){seconds='0'+seconds;}
if(milli<100){milli='0'+milli;}
if(milli<10){milli='0'+milli;}
return'"'+year+'-'+month+'-'+day+'T'+
hours+':'+minutes+':'+seconds+'.'+milli+'Z"';}
pairs=[];if($.isArray(o)){for(k=0;k<o.length;k++){pairs.push($.toJSON(o[k])||'null');}
return'['+pairs.join(',')+']';}
if(typeof o==='object'){for(k in o){if(hasOwn.call(o,k)){type=typeof k;if(type==='number'){name='"'+k+'"';}else if(type==='string'){name=$.quoteString(k);}else{continue;}
type=typeof o[k];if(type!=='function'&&type!=='undefined'){val=$.toJSON(o[k]);pairs.push(name+':'+val);}}}
return'{'+pairs.join(',')+'}';}};$.evalJSON=typeof JSON==='object'&&JSON.parse?JSON.parse:function(str){return eval('('+str+')');};$.secureEvalJSON=typeof JSON==='object'&&JSON.parse?JSON.parse:function(str){var filtered=str.replace(/\\["\\\/bfnrtu]/g,'@').replace(/"[^"\\\n\r]*"|true|false|null|-?\d+(?:\.\d*)?(?:[eE][+\-]?\d+)?/g,']').replace(/(?:^|:|,)(?:\s*\[)+/g,'');if(/^[\],:{}\s]*$/.test(filtered)){return eval('('+str+')');}
throw new SyntaxError('Error parsing JSON, source is not valid.');};$.quoteString=function(str){if(str.match(escape)){return'"'+str.replace(escape,function(a){var c=meta[a];if(typeof c==='string'){return c;}
c=a.charCodeAt();return'\\u00'+Math.floor(c/16).toString(16)+(c%16).toString(16);})+'"';}
return'"'+str+'"';};}(jQuery));

jQuery.fn.extend({
    alignCenter: function(x, y) {
	return this.each(function() {
	    var w = $(this).width();
	    var h = $(this).height();
	    var W = $(window).width();
	    var H = $(window).height();
	    var SL = $(window).scrollLeft();
	    var ST = $(window).scrollTop();
	    if(x == undefined || y == undefined) {
	        x = $(window).width()/2 + SL;
	        y = $(window).height()/2.5 + ST;
	    }
	    var marginLeft = Math.max(SL, Math.min(W + SL, parseInt(x + w/2)) - w) + 'px';
	    var marginTop  = Math.max(ST, Math.min(H + ST, parseInt(y + h/2)) - h) + 'px';
	    $(this).css({'left':marginLeft, 'top':marginTop});
	});
    },

    addRemoveClass: function(c, b) {
	return this.each(function() {
	  if(b) return $(this).addClass(c);
	  else  return $(this).removeClass(c);
	});
    }
});

function applyDisabled(o) {
    var all = o.find('select,input');
    all.not(all.not('.disabled *,.disabled').prop('disabled', false)).prop('disabled', true);
}

function showPopup(popup_type, x, y) {
    var html = $('#popup_' + popup_type).html();
    var popup = $.extend($('<div class="popup overlay"/>').html(html), {close:function(){
	this.closest('div.popupGroup').remove();
	if(this.deferred && this.deferred.state() == 'pending') this.deferred.resolve();
	return this;
    }});
    popup.on('click', 'button.cancel', function(){ popup.close(); });
    $('#popupStack').append($('<div class="popupGroup"/>').append('<div class="opaco"/>').append(popup));
    var deferred = $.Deferred();
    deferred.promise(popup);
    popup.deferred = deferred;
    return popup.data('popup', popup).alignCenter(x, y);
}

$(document).on('keydown', function(event) {
    if(event.keyCode) {
	var popup = $('#popupStack div.popup:last');
	if(popup.length > 0) {
	    popup = popup.data('popup');
	    if(event.keyCode === 27 && popup.find('div.dontclose').length == 0) {
		popup.close();
		return false;
	    }
	    if(event.keyCode === 13) {
		var button = popup.find('button.default');
		if(button.length == 1) {
		    button.click();
		    return false;
		}
	    }
	}
    }
    return true;
});

function dialog(content, onYes, onNo) {
    return myDialog(content, [{text:'Да',img:'img/accept-icon.png',handler:onYes,defaction:true},{text:'Нет',img:'img/delete-icon.png',handler:onNo}], {img:'img/dialog_question.png'});
}

function warning(text, hdr, onClose) {
    return myDialog(text, [{text:'Закрыть',defaction:true,img:'img/delete-icon.png',handler:onClose}], {header:(hdr || 'Предупреждение'),img:'img/alert.png'});
}

function notice(text, hdr) {
    return myDialog(text, [{text:'Закрыть',defaction:true,img:'img/delete-icon.png'}], {header:(hdr || 'Уведомление'),img:'img/success-icon.png'});
}

function myDialog(content, buttons, opt) {
    var popup = showPopup();
    popup.html('<div class="body"><div class="middle content"/></div><div class="footer"><hr></div>');
    if(content instanceof jQuery) popup.find('div.content').append(content);
    else popup.find('div.content').html(content);
    if(opt) {
	if(opt['header'])
	    popup.prepend($('<div class="header">&nbsp;'+opt['header']+'&nbsp;</div>'));
	if(opt['img'])
	    popup.find('div.body').prepend($('<div class="middle"><img src="'+opt['img']+'" alt=""></div>'));
    }
    for(var i in buttons) {
	var btn = buttons[i];
	var b = $('<button>'+btn['text']+'</button>')
	    .on('click', (function(h,popup,dontClose) { return function() { if(h) { h(popup); } if(!h || !dontClose) { popup.close(); } }; })(btn['handler'], popup, btn['dontClose']));
	if(btn['defaction'])
	    b.addClass('default');
	if(btn['img'])
	    b.prepend($('<img src="'+btn['img']+'" alt="">').css('margin-right', 4)).css('padding-left', 0);
	popup.find('div.footer').append(b);
    }
    return popup.alignCenter();
}

function getCookies() {
    var pairs = document.cookie.split(';');
    var cookies = {};
    for(var i in pairs) {
	try {
	    var pair = pairs[i].trim().split('=');
	    if(pair.length == 2)
		cookies[encodeURIComponent(pair[0])] = encodeURIComponent(pair[1]);
	} catch(e) {}
    }
    return cookies;
}

function request(data) {
    var defer = new $.Deferred;
    $.ajax({
	type:           'POST',
	url:            '/api',
	cache:          false,
	contentType:	'application/json; charset=UTF-8',
	data:           $.toJSON(data),
	dataType:       'json'
    }).done( function(result) {
	if(result) {
	    if(result['error']) {
		if(result['error'] === 'not logged in')
		    return login();
		if(result['error'] === 'access denied')
		    result['error'] = 'доступ запрещен';
		warning(result['cmd']+': '+result['error'], "Ошибка")
			.always(function(){defer.reject(result);});
	    } else {
		defer.resolve(result);
	    }
	} else { defer.reject(); }
    }).fail(function(){ defer.reject(); });
    return defer.promise();
}

function getPeerName(addr) {
    var defer = new $.Deferred;
    $.ajax({
	type:           'GET',
	url:            addr+'/api?json={"cmd":"getName"}',
	contentType:	'text/plain',
	cache:          false
    }).done( function(result, error) {
	if(result) {
	    var name = result['name'];
	    if(name != undefined) {
		defer.resolve(name.substring(0, 50));
		return;
	    }
	}
	defer.reject();
    }).fail(function(){
	defer.reject();
    });
    return defer.promise();
}

function invalidValue(field, text) {
    field.addClass('redBorder');
    warning(text, 'Ошибка', function(){ field.focus(); });
    return false;
}

var paramProperties = {
    Uk: { type:'float', min1: 44, max1: 56, min2: 55, max2: 69.5 },
    current: { type:'int', min1: 1, max1: 9, min2: 1, max2: 9 },
    Kt: { type:'int', min1: 0, max1: 144, min2: 0, max2: 180 },
    mode: { type:'enum', values: ['клиент', 'сервер'] },
    chargeMode: { type:'enum', values: ['нет', 'A', 'B', 'C'] },
    Uc: { type:'float', min1: 54.5, max1: 59, min2: 68.1, max2: 74 },
    Ctime: { type:'int', min1: 1, max1: 48, min2: 1, max2: 48 },
    manual: { type:'enum', values: ['нет', 'да'] },
    period: { type:'int', min1: 0, max1: 12, min2: 0, max2: 12, special: {0: 'откл'} },
    capacity: { type:'int', min1: 20, max1: 100, min2: 20, max2: 100 },
    U: { type:'float', min1: 42, max1: 57.6, min2: 52.5, max2: 72 },
    Ttime: { type:'int', min1: 1, max1: 24, min2: 1, max2: 24 },
    offAB: { type:'float', min1: 42, max1: 57.6, min2: 52.5, max2: 72 },
    off: { type:'float', min1: 42, max1: 57.6, min2: 52.5, max2: 72 },
    on: { type:'float', min1: 42, max1: 57.6, min2: 52.5, max2: 72 },
    completeness: { type:'int', min1: 0, max1: 4, min2: 0, max2: 4 },
    offSound: { type:'enum', values: ['нет', 'да'] },
    connectionAB: { type:'enum', values: ['нет', 'да'] },
};

function updateParameter(root, p, v) {
    if(p == 'serialNumber') return $('span.serialNumber').text(v);
    if(p == 'deviceName') {
	$('span.deviceName').text(v);
	if(v !== '') v += ' - ';
	document.title = v + 'UPS-1200';
	return;
    }
    if(p == 'time') {
	var d = new Date(v * 1000);
	return $('td.time').html(d.toLocaleDateString()+'<br>'+d.toLocaleTimeString());
    }
    if(typeof(v) == 'object') {
	var child = root.find('.'+p);
	child.data('config', v);
	for(var pp in v) {
	    updateParameter(child, pp, v[pp]);
	}
    }
    if(paramProperties[p]) {
	var prop = paramProperties[p];
	if(prop['type'] === 'float' && typeof(v) === 'number') {
	    v = Math.round(v * 100) / 100;
	}
	if(prop['type'] === 'enum') {
	    if(v >= 0 && v < prop['values'].length) v = prop['values'][v];
	    else v = 'invalid';
	}
	if(prop['type'] === 'bool') {
	    v = v ? 'да' : 'нет';
	}
	if(prop['special']) {
	    for(var i in prop['special']) {
		if(i == v) v = prop['special'][i];
	    }
	}
    }
    root.find('td.'+p).data('param', p).data('value', v).text(v);
}

function updateReadOnlyParameters() {
    return request({'cmd':'parametersRO'}).done(function(result) {
	var div = $('div.parameters');
	for(var p in result['parameters']) {
	    updateParameter(div, p, result['parameters'][p]);
	}
    }).always(function(){
	setTimeout(updateReadOnlyParameters, 1000);
    });
}

$(window).on('load', function() {
    request({'cmd':'parameters'}).done(function(result) {
	$('div.parameters, table.toolbar').removeClass('hidden');
	var div = $('div.parameters');
	for(var p in result['parameters']) {
	    updateParameter(div, p, result['parameters'][p]);
	}
    });
});

function submitValue(hash, popup, k)
{
    if(paramProperties[k]) {
	var prop = paramProperties[k];
        var configMode = $('div.parameters fieldset.system').data('config')['configMode'];
	switch(prop['type']) {
	case 'int':
	    var x = parseInt(popup.find('.'+k).val());
	    var min = configMode == 0xAB ? prop['min1'] : prop['min2'];
	    var max = configMode == 0xAB ? prop['max1'] : prop['max2'];
	    if(isNaN(x) || x < min || x > max) return invalidValue(popup.find('.'+k), 'Значение должно быть в диапазоне '+min+'...'+max);
	    break;
	case 'float':
	    var x = parseFloat(popup.find('.'+k).val());
	    var min = configMode == 0xAB ? prop['min1'] : prop['min2'];
	    var max = configMode == 0xAB ? prop['max1'] : prop['max2'];
	    if(isNaN(x) || x < min || x > max) return invalidValue(popup.find('.'+k), 'Значение должно быть в диапазоне '+min+'...'+max);
	    break;
	case 'string':
	    break;
	case 'enum':
	    x = popup.find('.'+k).prop('selectedIndex');
	    if(x < 0) return invalidValue(popup.find('.'+k), 'Необходимо выбрать одно из значений параметра');
	    break;
	}
	hash[k] = x;
	return true;
    }
    return false;
}

function updateForm(popup, c)
{
    for(var k in c) {
	var e = popup.find('.'+k);
	if(e.length > 0) {
	    switch(e[0].nodeName.toLowerCase()) {
		case 'input':
		    e.val(c[k]);
		    break;
		case 'select':
		    e.prop('selectedIndex', c[k]);
		    break;
	    }
	}
    }
}

$(document).on( 'click', 'div.parameters fieldset.charge td.icons img.edit', function() {
    var popup = showPopup('charge');
    var fs = $(this).closest('fieldset');
    var config = fs.data('config');
    updateForm(popup, config);
    popup.on('click', 'button.default', function() {
	popup.find('*').removeClass('redBorder');
	var c = {};
	if(!submitValue(c, popup, 'Uk')) return;
	if(!submitValue(c, popup, 'current')) return;
	if(!submitValue(c, popup, 'Kt')) return;
	if(!submitValue(c, popup, 'chargeMode')) return;
	var ctrl = getBusyOverlay( popup[0], {opacity:0.6} );
	request({'cmd':'setConfig','charge':c})
	    .done(function() { updateParameter($('div.parameters'), 'charge', c); $.extend(config, c); popup.close(); })
	    .always(function() { ctrl.remove(); });
    });
});

$(document).on( 'click', 'div.parameters fieldset.acharge td.icons img.edit', function() {
    var popup = showPopup('acharge');
    var fs = $(this).closest('fieldset');
    var config = fs.data('config');
    updateForm(popup, config);
    popup.on('click', 'button.default', function() {
	popup.find('*').removeClass('redBorder');
	var c = {};
	if(!submitValue(c, popup, 'Uc')) return;
	if(!submitValue(c, popup, 'Ctime')) return;
	if(!submitValue(c, popup, 'manual')) return;
	if(!submitValue(c, popup, 'period')) return;
	var ctrl = getBusyOverlay( popup[0], {opacity:0.6} );
	request({'cmd':'setConfig','acharge':c})
	    .done(function() { updateParameter($('div.parameters'), 'acharge', c); $.extend(config, c); popup.close(); })
	    .always(function() { ctrl.remove(); });
    });
});

$(document).on( 'click', 'div.parameters fieldset.test td.icons img.edit', function() {
    var popup = showPopup('test');
    var fs = $(this).closest('fieldset');
    var config = fs.data('config');
    updateForm(popup, config);
    popup.on('click', 'button.default', function() {
	popup.find('*').removeClass('redBorder');
	var c = {};
	if(!submitValue(c, popup, 'capacity')) return;
	if(!submitValue(c, popup, 'U')) return;
	if(!submitValue(c, popup, 'Ttime')) return;
	if(!submitValue(c, popup, 'manual')) return;
	if(!submitValue(c, popup, 'period')) return;
	var ctrl = getBusyOverlay( popup[0], {opacity:0.6} );
	request({'cmd':'setConfig','test':c})
	    .done(function() { updateParameter($('div.parameters'), 'test', c); $.extend(config, c); popup.close(); })
	    .always(function() { ctrl.remove(); });
    });
});

$(document).on( 'click', 'div.parameters fieldset.ctors td.icons img.edit', function() {
    var popup = showPopup('ctors');
    var fs = $(this).closest('fieldset');
    var config = fs.data('config');
    updateForm(popup, config);
    popup.on('click', 'button.default', function() {
	popup.find('*').removeClass('redBorder');
	var c = {};
	if(!submitValue(c, popup, 'offAB')) return;
	if(!submitValue(c, popup, 'off')) return;
	if(!submitValue(c, popup, 'on')) return;
	var ctrl = getBusyOverlay( popup[0], {opacity:0.6} );
	request({'cmd':'setConfig','ctors':c})
	    .done(function() { updateParameter($('div.parameters'), 'ctors', c); $.extend(config, c); popup.close(); })
	    .always(function() { ctrl.remove(); });
    });
});

$(document).on( 'click', 'div.parameters fieldset.system td.icons img.edit', function() {
    var popup = showPopup('system');
    var fs = $(this).closest('fieldset');
    var config = fs.data('config');
    updateForm(popup, config);
    for(var i = 0, m = 1; i < 11; i++, m <<= 1) {
        popup.find('input.mask-'+i).prop('checked', config['masks'] & m);
    }
    popup.on('click', 'button.default', function() {
	popup.find('*').removeClass('redBorder');
	var c = {};
	if(!submitValue(c, popup, 'completeness')) return;
	if(!submitValue(c, popup, 'offSound')) return;
	if(!submitValue(c, popup, 'connectionAB')) return;
	var x = 0;
        for(var i = 0, m = 1; i < 11; i++, m <<= 1) {
            if(popup.find('input.mask-'+i).prop('checked'))
		x |=  m;
        }
	c['masks'] = x;
	var ctrl = getBusyOverlay( popup[0], {opacity:0.6} );
	request({'cmd':'setConfig','system':c})
	    .done(function() { updateParameter($('div.parameters'), 'system', c); $.extend(config, c); popup.close(); })
	    .always(function() { ctrl.remove(); });
    });
});

$(document).on( 'click', 'div.parameters fieldset.ethernet td.icons img.edit', function() {
    var popup = showPopup('ethernet');
    var fs = $(this).closest('fieldset');
    var config = fs.data('config');
    popup.find('.address').val( config['address']);
    popup.find('.netmask').val( config['netmask']);
    popup.find('.gateway').val( config['gateway']);
    popup.find('.dns').val( config['dns']);
    popup.on('click', 'button.default', function() {
	var c = {};
	c['address'] = popup.find('.address').val();
	c['netmask'] = popup.find('.netmask').val();
	c['gateway'] = popup.find('.gateway').val();
	c['dns'] = popup.find('.dns').val();
	var ctrl = getBusyOverlay( popup[0], {opacity:0.6} );
	request({'cmd':'setEthConfig','config':c})
	    .done(function() { updateParameter($('div.parameters'), 'ethernet', c); $.extend(config, c); popup.close(); })
	    .always(function() { ctrl.remove(); });
    });
});

$(document).on( 'click', 'div.parameters td.val.clickable', function() {
    var tr = $(this).closest('tr');
    var p = tr.data('param');
    var v = tr.data('value');
    var m = tr.find('td:first').text();
    if(paramProperties[p]) {
	var prop = paramProperties[p];
	switch(prop['type']) {
	case 'int':
	case 'float':
	    var text = m+': <input type="text" class="'+prop['type']+'" size="16" maxlength="12" value="'+v+'">';
	    if(prop['unit']) text += ' ' + prop['unit'];
	    if(prop['special']) {
		text += '<br>';
		for(var i in prop['special']) {
		    text += '<input class="special" type="checkbox" value="'+i+'" '+(v == i ? 'checked="checked"' : '')+'> '+prop['special'][i]+'<br>';
		}
		text = '<div class="left">'+text+'</div>';
	    }
	    break;
	case 'string':
	    var text = m+': <input type="text" size="16" maxlength="255" value="'+v+'">';
	    if(prop['unit']) text += ' ' + prop['unit'];
	    break;
	case 'enum':
	    var select = $('<select/>');
	    for(var o in prop['values']) select.append('<option'+(o == v ? ' selected="selected"' : '')+'>'+prop['values'][o]+'</option>');
	    select.prop('selectedIndex', v);
	    text = $('<div/>').text(m+': ').append(select);
	    break;
	case 'flags':
            var text = $('<fieldset class="left"/>');
	    text.append($('<legend/>').text(m));
	    for(var o in prop['flags']) {
		text.append('<input type="checkbox"'+((v & 1) ? 'checked="checked"' : '')+'> '+prop['flags'][o]+'<br>');
		v = v / 2.0;
	    }
	    break;
	}
    } else {
	return false;
    }
    var popup = myDialog(text, [{text:'OK', defaction:true, img:'img/accept-icon.png', handler:function(){
	popup.find('*').removeClass('redBorder');
	switch(prop['type']) {
	case 'int':
	case 'float':
	    var cb = popup.find('input[type="checkbox"]');
	    if(cb.prop('checked')) {
		var v = Number(cb.prop('value'));
	    } else {
		var v = prop['type'] == 'int' ? parseInt(popup.find('input').val()) : parseFloat(popup.find('input').val());
		if(isNaN(v) || v < prop['min'] || v > prop['max']) return invalidValue(popup.find('input'), 'Значение должно быть в диапазоне '+prop['min']+'...'+prop['max']);
	    }
	    break;
	case 'string':
	    var v = popup.find('input').val();
	    break;
	case 'enum':
	    var v = popup.find('select').prop('selectedIndex');
	    if(v < 0) return invalidValue(popup.find('select'), 'Не выбрано значение!');
	    break;
	case 'flags':
	    var v = 0.0;
	    var m = 1.0;
	    popup.find('input').each(function(i){
		if($(this).prop('checked')) v = v + m;
		m = m * 2;
	    });
	    break;
	}
	var ctrl = getBusyOverlay( popup[0], {opacity:0.6} );
	request({'cmd':'setParameter','parameter':p,'value':v})
	    .done(function() { updateParameter($('div.parameters'), p, v); popup.close(); })
	    .always(function() { ctrl.remove(); });
    }, dontClose:true}, {text:'Закрыть',img:'img/delete-icon.png'}], {header:('Изменение настройки'),img:'img/Settings-icon.png'});
    popup.on('change', 'input[type="checkbox"].special', function(){
	$(this).siblings().prop('disabled', $(this).prop('checked'));
    });
    popup.find('input[type="checkbox"]').change();
});

/* Перемещение диалогов за заголовок */
var dragging = {'on':false};
$(document).on( 'mousedown', 'div.header', function(e) {
    var popup = $(this).parent();
    dragging.startLeft = parseInt(popup.css('left')) - e.pageX;
    dragging.startTop = parseInt(popup.css('top')) - e.pageY;
    dragging.obj = popup;
    dragging.on = true;
    $(document).on( 'mousemove', function(e) {
	dragging.obj.css( {'left':dragging.startLeft + e.pageX, 'top':dragging.startTop + e.pageY} );
	return false;
    });
    return false;
});

$(document).on( 'mouseup', function(e) {
    if(dragging.on) {
	$(document).off('mousemove');
	dragging.obj.css( {'left':dragging.startLeft + e.pageX, 'top':dragging.startTop + e.pageY} );
	dragging.on = false;
	$(document.elementFromPoint(e.pageX-$(window).scrollLeft(), e.pageY-$(window).scrollTop())).trigger('drop', dragging.obj);
    }
});


function login() {
    var popup = showPopup('login');
    popup.find('input.login').focus();
    popup.on('click', 'button.default', function(){
	var login = popup.find('input.login').val();
	var password = popup.find('input[type="password"]').val();
	var ctrl = getBusyOverlay( popup[0], {opacity:0.6} );
	request({'cmd':'login','login':login,'password':password})
	.done( function(result) {
	    if(result['error2']) {
		popup.find('div.error').text('Ошибка: '+result['error2']);
	    } else {
		popup.find('div.error').parent().text('Выполняется вход...');
		documentReload();
	    }
	}).always(function(){ctrl.remove();});
    });
    return popup;
}

function documentReload() {
    document.location.href = document.location.href.split('?')[0].replace(/#$/,'');
}

$(document).on( 'click', 'img#exit', function() {
    document.cookie = "password=;expires=Thu, 01 Jan 1970 00:00:00 GMT;path=/";
    documentReload();
});

$(document).on( 'click', 'button.chPasswd', function() {
    var cookies = getCookies();
    var popup = myDialog($('#popup_passwd').html(), [{text:'Изменить',defaction:true,dontClose:true,img:'img/accept-icon.png',handler:function(popup){
	popup.find('*').removeClass('redBorder');
	var current = popup.find('input.current').val();
	var new1 = popup.find('input.new1').val();
	var new2 = popup.find('input.new2').val();
	if(new1 != new2) return invalidValue(popup.find('input.new1, input.new2'), 'Новые пароли не совпадают');
	var ctrl = getBusyOverlay( popup[0], {opacity:0.6} );
	request({'cmd':'chpass','current':current,'new':new1})
	    .then( function() {
		return request({'cmd':'login','login':cookies['login'],'password':new1})
		    .done(function(){ popup.close(); });
	    })
	    .always(function(){ctrl.remove();});
    }},{text:'Отмена',img:'img/delete-icon.png'}], {header:'Изменение пароля',img:'img/keys.png'});
    if(cookies['login'])
	popup.find('div.header').html('Смена пароля для '+cookies['login']);
    popup.find('input.current').focus();
});

$(document).on( 'click', 'span.devName', function() {
    var popup = myDialog('Имя устройства: <input type="text">', [{text:'OK',img:'img/accept-icon.png',handler:function(popup){
	var name = popup.find('input').val();
	var ctrl = getBusyOverlay( popup[0], {opacity:0.6} );
	request({'cmd':'setDeviceName','name':name})
	    .done(function(){ $('span.deviceName').text(name); popup.close(); })
	    .always(function(){ctrl.remove();});
    }, defaction:true,dontClose:true},{text:'Отмена',img:'img/delete-icon.png'}], {header:'Изменение имени устройства'});
    popup.find('input').val($('span.deviceName').text()).select();
});

$(document).on( 'click', 'button.sslcerts', function() {
    var popup = $.extend(showPopup('sslInfo'),{updateCertinfo: function(result){
	var info = result['certinfo'];
	if(typeof(info) === 'string') {
	    this.find('table tr.no-cert td').text(info).parent().show().siblings().hide();
	} else {
	    this.find('.subjectitem,.issueritem').remove();
	    var c2name = {'C':'Country','CN':'Common Name','O':'Organization','OU':'Organizational Unit','L':'Location','ST':'State'};
	    for(var p in info) {
		this.find('table td.'+p).text(info[p]);
		if(p === 'subject' || p == 'issuer') {
		    var pp = info[p].split('/');
		    for(var i in pp) {
			var x = pp[i].split('=');
			if(x.length == 2) {
			    $('<tr class="'+p+'item"><td class="right">'+(c2name[x[0]] || x[0])+':</td><td class="left bold">'+x[1]+'</td></tr>')
			    .insertAfter( this.find('tr.'+p) );
			}
		    }
		}
	    }
	    this.find('table tr.no-cert').hide().siblings().show();
	}
	this.alignCenter();
    }}).on('click', 'a.load', function() {
	var popup2 = showPopup('loadSSL');
	popup2.on('click', 'button.default', function() {
	    var sslcert = popup2.find('textarea.sslcert').val();
	    var sslkey = popup2.find('textarea.sslkey').val();
	    var sslca = popup2.find('textarea.sslca').val();
	    var ctrl = getBusyOverlay( popup2[0], {opacity:0.6,text:'Загрузка сертификатов...'} );
	    request({'cmd':'certs','sslcert':sslcert,'sslkey':sslkey,'sslca':sslca}).done( function(result) {
		popup.updateCertinfo(result);
		popup2.close();
	    }).always(function(){ctrl.remove();});
	}).find('.cacert').parent().hide();
    }).on('click', 'button.default', function(){ popup.close(); });
    var ctrl = getBusyOverlay( popup[0], {opacity:0.6,text:'Запрос данных...'} );
    request({'cmd':'certinfo'}).done( function(result) {
	popup.updateCertinfo(result);
    }).always(function(){ctrl.remove();});
});

var scrollTimer;

function scrollDown() {
    var o = $("table.layout tr.result iframe");
    if(o.length == 0) return;
    var h = o.contents().height();
    o.contents().scrollTop(h);
}

var needRestartFlag = false;
var needRebootFlag = false;

function needRestart() { needRestartFlag = true; }
function needReboot() { needRebootFlag = true; }

function doUpdate(op, pkgs) {
    var url = 'update?op='+op;
    if(pkgs)
	url += '&pkgs=' + encodeURIComponent(pkgs);
    if(op === 'list_upgradable')
	$('table.layout').prepend('<tr class="result"><td colspan="2"><fieldset class="result list"><legend>Список доступных обновлений: <button>скрыть</button></legend><table border="2" cellspacing="0" cellpadding="4" width="100%"><tr><th>Имя пакета</th><th>Установленная версия</th><th>Новая версия</th><th>Выбран</th></tr></table><iframe name="update_target" src="'+url+'" style="width:0;height:0;border:0px solid #fff;"/></fieldset></td></tr>');
    else
	$('table.layout').prepend('<tr class="result"><td colspan="2"><fieldset class="result inlineblock"><legend>Результат: <button>скрыть</button></legend><iframe name="update_target" src="'+url+'"  style="display:block;width:inherit;height:200px;background-color:white"/></fieldset></td></tr>');
    scrollTimer = setInterval(scrollDown, 200);
    $('table.layout tr.result').data('op', op);
    $('button.softupdate, table.layout tr.result fieldset legend button').prop('disabled', true);
}

function stopUpdate() {
    var op = $('table.layout tr.result').data('op');
    if(scrollTimer !== undefined) {
	clearInterval(scrollTimer);
	scrollTimer = undefined;
	scrollDown();
    }
    $('table.layout tr.result fieldset legend button, button.softupdate').prop('disabled', false);
    if($('table.layout tr.result table tr').length > 1) {
	$('table.layout tr.result fieldset.result.list > button').remove();
	$('table.layout tr.result fieldset.result.list')
	    .append('<button class="icon selectAll" style="margin:4px"><img src="img/tick-icon.png" alt=""> Выбрать все</button>')
	    .append('<button class="icon unselectAll" style="margin:4px"><img src="img/untick-icon.png" alt=""> Отменить все</button>')
	    .append('<button id="updateSelected" class="icon" style="margin:4px"><img src="img/install-icon.png" alt=""> Установить выбранные пакеты</button>');
    } else {
	$('table.layout tr.result fieldset.result.list table').append('<tr><td colspan="4"><div class="error">Нет доступных обновлений</div></td></tr>');
    }
    if(needRebootFlag) {
	needRebootFlag = false;
	needRestartFlag = false;
	dialog('Требуется перезагрузка устройства. Перезагрузить сейчас?', function() { request({'cmd':'reboot'}); } );
    } else if(needRestartFlag) {
	needRestartFlag = false;
	dialog('Пакет <b>3gd</b> обновлен. Требуется перезапуск 3gd. Перезапустить сейчас?', function() { request({'cmd':'restart'}); } );
    }
    if(op && op == 'update') { doUpdate('list_upgradable'); }
}

$(document).on( 'click', 'table.layout tr.result fieldset.result.list .selectAll, table.layout tr.result fieldset.result.list .unselectAll', function() {
    $('table.layout tr.result fieldset.result.list table :checkbox').not(':disabled').prop('checked', $(this).hasClass('selectAll'));
});

$(document).on( 'click', 'table.layout tr.result fieldset.result legend button', function() {
    $(this).closest('tr.result').remove();
});

function addToListUpgradable(name, curVer, newVer) {
    $('table.layout tr.result table').append('<tr><td>'+name+'</td><td>'+curVer+'</td><td>'+newVer+'</td><td><input type="checkbox" checked="checked"></td></tr>');
    $('table.layout tr.result table tr:last td:first').data('pkg', name);
}

$(document).on( 'click', 'button.softupdate,#updateSelected', function() {
    var id = this.id;
    var op = 'update';
    if(id === 'updateSelected') {
	var selected = $('table.layout tr.result fieldset.result.list table tr').has('input:checked');
	if(selected.length < 1) {
	    warning('Не выбран ни один пакет');
	    return false;
	}
	var pkgs = selected.find('td:first').map(function() {
	    return $(this).data('pkg');
	}).get().join(' ');
	op = 'upgrade';
    }
    $('table.layout tr.result').remove();
    doUpdate(op, pkgs);
});

$(document).on( 'click', 'table.toolbar button.restart', function() {
    dialog('Вы действительно хотите выполнить перезапуск UPS-1200?', function() { request({'cmd':'restart'}); } );
});

$(document).on( 'click', 'table.toolbar button.reboot', function() {
    dialog('Вы действительно хотите выполнить полную перезагрузку устройства?', function() { request({'cmd':'reboot'}); } );
});
