#!/usr/bin/env python
# encoding: utf-8

import web
import json
import time
import hashlib
import pyroute2
import subprocess

urls = (
        '/', 'index',
        '/api', 'api'
        )

class WebApplication(web.application):
    def run(self, *middleware):
        # Генерируем ключ сайта для аутентификации
        global session_key
        try:
            with open('/dev/urandom', 'r') as f:
                session_key = f.read(20)
        except:
            session_key = 'gjkfhnjkdashfjkifheu'
        # Формируем хэш пользователей для аутентификации (пока только один пользователь admin)
        global users
        users = {'admin':{'password':''}}
        try:
            with open('/etc/snmp/users.txt', 'r') as f:
                users['admin']['password'] = f.read()
        except:
            pass
        func = self.wsgifunc(*middleware)
        return web.httpserver.runsimple(func, ('0.0.0.0', 80))

class index:
    def GET(self):
        raise web.seeother('/static/index.html')

class api:
    def set_iface_ip(self, ifname, ifaddr):
        return

    def execute_command(self, request, response):
        if 'cmd' in request:
            cmd = request['cmd']
        else:
            response['error'] = "no 'cmd' field"
            return

        response['cmd'] = cmd
        global users

        if cmd == 'login':
            login = 'admin'
            if not 'password' in request:
                response['error'] = "no 'password' field"
                return
            if login in users and request['password'] == users[login]['password']:
                self.setAuth(login)
                request['_USERNAME'] = login
            else:
                response['error2'] = 'неверное имя или пароль'
        elif cmd == 'chpass':
            if not 'current' in request:
                response['error'] = "no 'current' field"
                return
            if not 'new' in request:
                response['error'] = "no 'new' field"
                return
            login = request['_USERNAME']
            if not login in users:
                response['error'] = "no such user"
                return
            if request['current'] != users[login]['password']:
                response['error'] = "неверный текущий пароль"
                return
            users[login]['password'] = request['new']
            try:
                with open('/etc/snmp/users.txt', 'w') as f:
                    f.write(request['new'])
                subprocess.call(['sync'])
            except:
                response['error'] = 'cannot save password file'
        elif cmd == 'parameters':
            # парсим /etc/network/interfaces
            try:
                with open('/etc/network/interfaces', 'r') as f:
                    lines = f.readlines()
            except:
                pass
            address = ''
            netmask = ''
            gateway = ''
            dns = ''
            eth0 = False
            for line in lines:
                word = line.split()
                if len(word) < 2:
                    continue
                if word[0] == 'iface':
                    eth0 = word[1] == 'eth0'
                if eth0:
                    if word[0] == 'address':
                        address = word[1]
                    elif word[0] == 'netmask':
                        netmask = word[1]
                    elif word[0] == 'gateway':
                        gateway = word[1]
                    elif word[0] == 'dns-nameservers':
                        dns = word[1]
            response['parameters'] = {'ethernet':{'address':address,'netmask':netmask,'gateway':gateway,'dns':dns}}
            # получаем конфиг UPS из внешнего объекта
            global upsObject
            if upsObject != None:
                config = upsObject.getConfig()
                if len(config) > 250:
                    response['parameters']['charge'] = {'Uk':(config[32]+440)/10.0, 'current':config[33], 'Kt':config[34]*2, 'chargeMode':config[35]}
                    response['parameters']['acharge'] = {'Uc':(config[42]+545)/10.0, 'Ctime':config[43], 'manual':config[44], 'period':config[45]}
                    response['parameters']['test'] = {'capacity':config[52], 'U':(config[53]+420)/10.0, 'Ttime':config[54], 'manual':config[55], 'period':config[56]}
                    response['parameters']['ctors'] = {'offAB':(config[62]+420)/10.0, 'off':(config[63]+420)/10.0, 'on':(config[64]+420)/10.0}
                    response['parameters']['system'] = {'configMode':config[1], 'completeness':config[72], 'offSound':config[73], 'connectionAB':config[74], 'masks':config[237]|(config[238] << 8)}
        elif cmd == 'restart':
            if upsObject != None:
                upsObject.restart()
        elif cmd == 'setEthConfig':
            if not 'config' in request:
                response['error'] = "no 'config' field"
                return
            config = request['config']
            if not 'address' in config:
                response['error'] = "no 'address' field"
                return
            if not 'netmask' in config:
                response['error'] = "no 'netmask' field"
                return
            if not 'gateway' in config:
                response['error'] = "no 'gateway' field"
                return
            if not 'dns' in config:
                response['error'] = "no 'dns' field"
                return
            # Создаем новый /etc/network/interfaces
            try:
                with open('/etc/network/interfaces', 'w') as f:
                    f.write("auto lo\niface lo inet loopback\n\nauto eth0\niface eth0 inet static\n\taddress {0}\n\tnetmask {1}\n\tgateway {2}\n\tdns-nameservers {3}".format(config['address'], config['netmask'], config['gateway'], config['dns']))
                subprocess.call(['sync'])
            except:
                response['error'] = 'cannot create /etc/network/interfaces'
            # применяем новые настройки к интерфейсу
            subprocess.call(["ifconfig", "eth0", "inet", config['address'], "netmask", config['netmask']])
            try:
                with open('/etc/resolv.conf', 'w') as f:
                    f.write("nameserver {0}\n".format(config['dns']))
                subprocess.call(['sync'])
            except:
                response['error'] = 'cannot create /etc/resolv.conf'
            ip = pyroute2.IPRoute()
            ip.route('replace', dst='0.0.0.0', dst_len=0, gateway=config['gateway'])
            ip.close()
        elif cmd == 'setConfig':
            if upsObject != None:
                # Создаем конфигурацию.
                config = [None] * 256
                if 'charge' in request:
                    c = request['charge']
                    if 'Uk' in c:
                        config[32] = int(round(c['Uk'] * 10.0 - 440))
                    if 'current' in c:
                        config[33] = c['current']
                    if 'Kt' in c:
                        config[34] = int(round(c['Kt'] / 2.0))
                    if 'chargeMode' in c:
                        config[35] = c['chargeMode']

                if 'acharge' in request:
                    c = request['acharge']
                    if 'Uc' in c:
                        config[42] = int(round(c['Uc'] * 10.0 - 545))
                    if 'Ctime' in c:
                        config[43] = c['Ctime']
                    if 'manual' in c:
                        config[44] = c['manual']
                    if 'period' in c:
                        config[45] = c['period']

                if 'test' in request:
                    c = request['test']
                    if 'capacity' in c:
                        config[52] = c['capacity']
                    if 'U' in c:
                        config[53] = int(round(c['U'] * 10.0 - 420))
                    if 'Ttime' in c:
                        config[54] = c['Ttime']
                    if 'manual' in c:
                        config[55] = c['manual']
                    if 'period' in c:
                        config[56] = c['period']

                if 'ctors' in request:
                    c = request['ctors']
                    if 'offAB' in c:
                        config[62] = int(round(c['offAB'] * 10.0 - 420))
                    if 'off' in c:
                        config[63] = int(round(c['off'] * 10.0 - 420))
                    if 'on' in c:
                        config[64] = int(round(c['on'] * 10.0 - 420))

                if 'system' in request:
                    c = request['system']
                    if 'completeness' in c:
                        config[72] = c['completeness']
                    if 'offSound' in c:
                        config[73] = c['offSound']
                    if 'connectionAB' in c:
                        config[74] = c['connectionAB']
                    if 'masks' in c:
                        config[237] = c['masks'] & 0xff
                        config[238] = c['masks'] >> 8

                if not upsObject.writeConfig(config):
                    response['error'] = 'ошибка записи конфигурации в UPS'
            else:
                response['error'] = 'no UPS'
        else:
            response['error'] = 'unknown command'

    def compute_nonce(self, timestamp):
        global session_key
        mac = hashlib.md5()
        mac.update(timestamp + session_key)
        return mac.hexdigest()

    def checkAuth(self, request, response):
        try:
            login = web.cookies().login
            tm = web.cookies().time
            nonce = web.cookies().nonce
            password = web.cookies().password
            if nonce != self.compute_nonce(tm):
                response["error"] = 'not logged in'
                response["error2"] = 'invalid nonce'
                return False

            tmi = int(tm)
            now = int(time.time())
            if now < tmi or (now - tmi) > 86400:
                response["error"] = 'not logged in'
                response["error2"] = 'данные футентификации устарели'
                return False

            global users
            try:
                # вычисляем правильный хэш
                mac = hashlib.md5()
                mac.update(login + users[login]['password'] + tm + nonce)
                pwd = mac.hexdigest()
                if password != pwd:
                    raise 'error'
            except:
                response["error"] = 'not logged in'
                response["error2"] = 'неверное имя или пароль'
                return False
        except:
            response["error"] = 'not logged in'
            return False

        request['_USERNAME'] = login
        if (now - tmi) > 60:
            self.setAuth(login)
        return True

    def setAuth(self, login):
        global users
        password = users[login]['password']
        tm = str(int(time.time()))
        nonce = self.compute_nonce(tm)
        mac = hashlib.md5()
        mac.update(login + password + tm + nonce)
        web.setcookie('login', login)
        web.setcookie('time', tm)
        web.setcookie('nonce', nonce)
        web.setcookie('password', mac.hexdigest())

    def process(self, j):
        web.header('Content-Type', 'application/json; charset=utf-8')
        web.header('Cache-Control', 'no-cache')
        request = json.loads(j)
        request['_REMOTEADDR'] = web.ctx.ip
        request['_PERMISSIONS'] = 0x0000ffff
        response = {}
        if 'cmd' in request:
            cmd = request['cmd']
        else:
            return '{"error":"no cmd field"}'

        if cmd == 'login' or self.checkAuth(request, response):
            self.execute_command(request, response)

        return json.dumps(response)

    def GET(self):
        parameters = web.input()
        if hasattr(parameters, 'json'):
            return self.process(parameters.json)
        return '{"error":"invalid request"}'

    def POST(self):
        return self.process(web.data())

def runWebServer(ups = None):
    web.config.debug = False
    global upsObject
    upsObject = ups
    app = WebApplication(urls, globals())
    app.run()

if __name__ == "__main__":
    runWebServer()
