#!/usr/bin/env python
# encoding: utf-8

import signal
import serial
import time
import threading
import netsnmpagent
import os
import sys
import webinterface

snmpRoot = '.1.3.6.1.4.1.32109.10001'
stop = False

# Класс приема данных от UPS
class SerialRecv:
    # Основные параметры
    mainParams = []
    # Парабетры АКБ
    abParams = []
    # Конфигурация UPS
    config = []

    def __init__(self, ser):
        self.ser = ser              # последовательный порт, который будем читать
        self.data = []              # данные пакета
        self.escape = False
        self.mutex = threading.Lock()
        self.config_mutex = threading.Lock()                # Mutex запроса конфигурации.

    def run(self):
        global stop
        while not stop:
            try:
                byte = ord(self.ser.read(1))
            except:
                continue
            if byte == 0x7e:
                if len(self.data) > 4 and len(self.data) < 78:
                    # получено сообщение
                    # проверяем контрольную сумму
                    s = 0
                    for c in self.data:
                        s = s ^ c
                    if s == 0 and self.data[0] == 0x7f:
                        print ' '.join('{:02x}'.format(c) for c in self.data)
                        if self.data[1] == 0x80:
                            # Ответ на команду 0x00 - основные параметры
                            with self.mutex:
                                self.mainParams = self.data
                        elif self.data[1] == 0x81:
                            # Ответ на команду 0x01
                            if self.data[2] == 0:
                                # Параметры центральной платы RC-01
                                pass
                            elif self.data[2] == 1:
                                # Параметры АКБ
                                with self.mutex:
                                    self.abParams = self.data
                            elif self.data[2] > 1 and self.data[2] < 6:
                                # Параметры выпрямителя RC-48
                                pass
                        elif self.data[1] == 0x91:
                            # ответ на команду чтения конфигурации
                            if len(self.data) > 37:
                                addr = self.data[2] | (self.data[3] << 8)
                                self.config[addr:addr+32] = self.data[4:36]
                                if addr == 0:
                                    self.ser.write('\x7e\x00\x11\x20\x00\x31\x7e')
                                elif addr == 32:
                                    self.ser.write('\x7e\x00\x11\x40\x00\x51\x7e')
                                elif addr == 64:
                                    self.config[96:224] = [0] * 128
                                    self.ser.write('\x7e\x00\x11\xe0\x00\xf1\x7e')
                                else:
                                    # TODO конфиг успешно прочитан
                                    self.config_mutex.release()
                                    pass
                            else:
                                # TODO ошибка - слишком короткий ответ!
                                pass
                        elif self.data[1] == 0x92:
                            # ответ на команду записи конфигурации
                            addr = self.data[2] | (self.data[3] << 8)
                            if addr == 32:
                                # записываем вторую половину конфигурации
                                s = '\x7e\x00\x12\x40\x00'
                                sum = 0x52
                                sum2 = 0
                                for i in range(64, 96):
                                    s += chr(self.config[i])
                                    sum ^= self.config[i]
                                    sum2 += self.config[i]
                                s += chr(sum2 & 0xff)
                                sum ^= sum2 & 0xff
                                s += chr(sum)
                                s += '\x7e'
                                self.ser.write(s)
                            elif addr == 64:
                                # записываем третью половину конфигурации
                                s = '\x7e\x00\x12\xe0\x00'
                                sum = 0xf2
                                sum2 = 0
                                for i in range(224, 256):
                                    s += chr(self.config[i])
                                    sum ^= self.config[i]
                                    sum2 += self.config[i]
                                s += chr(sum2 & 0xff)
                                sum ^= sum2 & 0xff
                                s += chr(sum)
                                s += '\x7e'
                                self.ser.write(s)
                            else:
                                # запись окончена
                                self.config_mutex.release()
                self.data = []
                self.escape = False
            elif byte == 0x7d:
                self.escape = True
            else:
                if self.escape:
                    byte += 0x20
                    self.escape = False
                if len(self.data) < 78:
                    self.data.append(byte)

    def getMainParams(self):
        with self.mutex:
            p = self.mainParams[:]
        return p

    def getAbParams(self):
        with self.mutex:
            p = self.abParams[:]
        return p

    def getConfig(self):
        # Захватываем mutex чтения конфига (блокируемся если идет чтение другим потоком)
        self.config_mutex.acquire()
        # mutex захвачен - отправляем запрос чтения конфигурации
        self.ser.write('\x7e\x00\x11\x00\x00\x11\x7e')
        # Так как mutex уже захвачен, здесь мы заблокируемся
        # TODO предусмотреть таймаут!
        self.config_mutex.acquire()
        # Конфиг получен. Копируем его себе и освобождаем mutex
        c = self.config[:]
        self.config_mutex.release()
        return c

    def writeConfig(self, config):
        self.config_mutex.acquire()
        # обновляем текущий конфиг не-None значениями
        for i, x in enumerate(config):
            if x != None:
                self.config[i] = x
        # отправляем команду записи конфигурации
        s = '\x7e\x00\x12\x20\x00'
        sum = 0x32
        sum2 = 0
        for i in range(32, 64):
            x = self.config[i]
            sum ^= x
            sum2 += x
            if x == 0x7e or x == 0x7d:
                s += '\x7d'
                x -= 0x20
            s += chr(x)
        s += chr(sum2 & 0xff)
        sum ^= sum2 & 0xff
        s += chr(sum)
        s += '\x7e'
        self.ser.write(s)
        return True

    def restart(self):
        self.ser.write('\x7e\x00\x09\xaa\xbb\xcc\xd4\x7e')

# Устанавливаем обработчик сигналов
def TermHandler(signum, frame):
    global stop
    stop = True

signal.signal(signal.SIGINT, TermHandler)
signal.signal(signal.SIGTERM, TermHandler)

ser = serial.Serial(
        port = '/dev/ttyS1',
        baudrate = 115200,
        parity = serial.PARITY_ODD,
        stopbits = serial.STOPBITS_ONE,
        bytesize = serial.EIGHTBITS
)

ser.isOpen()

rcv = SerialRecv(ser)

def poller():
    n = 0
    request = [
            '\x7e\x00\x00\x00\x7e',
            '\x7e\x00\x01\x00\x01\x7e',
            '\x7e\x00\x01\x01\x00\x7e',
            '\x7e\x00\x01\x02\x03\x7e',
            '\x7e\x00\x01\x03\x02\x7e',
            '\x7e\x00\x01\x04\x05\x7e',
            '\x7e\x00\x01\x05\x04\x7e'
            ]
    global stop
    while not stop:
        time.sleep(1)
        ser.write(request[n])
        n += 1
        if n == len(request):
            n = 0

# Запускаем поллер в отдельном потоке
thr1 = threading.Thread(target=poller, name='poller')
thr1.daemon = True
thr1.start();

# Запускаем приемник в отдельном потоке
thr2 = threading.Thread(target=rcv.run, name='rcv.run')
thr2.daemon = True
thr2.start()

# Запускаем web-сервер
thr3 = threading.Thread(target=webinterface.runWebServer, name='WebServer', args=(rcv,))
thr3.daemon = True
thr3.start()

try:
	agent = netsnmpagent.netsnmpAgent(
		AgentName      = "SimpleAgent",
		MasterSocket   = '/var/run/agentx/snmpd-agentx.sock',
		PersistenceDir = '/var/lib/net-snmp'
	)
except netsnmpagent.netsnmpAgentException as e:
	print("{0}".format(e))
	sys.exit(1)

alarm       = agent.Integer32(oidstr=snmpRoot + '.1', writable=False)
version     = agent.Integer32(oidstr=snmpRoot + '.2', writable=False)
subversion  = agent.Integer32(oidstr=snmpRoot + '.3', writable=False)
UloadVar    = agent.Integer32(oidstr=snmpRoot + '.4.1', writable=False)
UabVar      = agent.Integer32(oidstr=snmpRoot + '.4.2', writable=False)
U220Var     = agent.Integer32(oidstr=snmpRoot + '.4.3', writable=False)
IloadVar    = agent.Integer32(oidstr=snmpRoot + '.4.4', writable=False)
IabVar      = agent.Integer32(oidstr=snmpRoot + '.4.5', writable=False)
PVar        = agent.Integer32(oidstr=snmpRoot + '.4.6', writable=False)
TVar        = agent.Integer32(oidstr=snmpRoot + '.4.7', writable=False)
discharge   = agent.Integer32(oidstr=snmpRoot + '.4.8', writable=False)
sensor1     = agent.Integer32(oidstr=snmpRoot + '.5.1', writable=False)
sensor2     = agent.Integer32(oidstr=snmpRoot + '.5.2', writable=False)
sensor3     = agent.Integer32(oidstr=snmpRoot + '.5.3', writable=False)
sensor4     = agent.Integer32(oidstr=snmpRoot + '.5.4', writable=False)
auto1       = agent.Integer32(oidstr=snmpRoot + '.6.1', writable=False)
auto2       = agent.Integer32(oidstr=snmpRoot + '.6.2', writable=False)
auto3       = agent.Integer32(oidstr=snmpRoot + '.6.3', writable=False)
auto4       = agent.Integer32(oidstr=snmpRoot + '.6.4', writable=False)
auto5       = agent.Integer32(oidstr=snmpRoot + '.6.5', writable=False)
auto6       = agent.Integer32(oidstr=snmpRoot + '.6.6', writable=False)
alarm0      = agent.Integer32(oidstr=snmpRoot + '.7.1', writable=False)
alarm1      = agent.Integer32(oidstr=snmpRoot + '.7.2', writable=False)
alarm2      = agent.Integer32(oidstr=snmpRoot + '.7.3', writable=False)
alarm3      = agent.Integer32(oidstr=snmpRoot + '.7.4', writable=False)
alarm4      = agent.Integer32(oidstr=snmpRoot + '.7.5', writable=False)
alarm5      = agent.Integer32(oidstr=snmpRoot + '.7.6', writable=False)
alarm6      = agent.Integer32(oidstr=snmpRoot + '.7.7', writable=False)
alarm7      = agent.Integer32(oidstr=snmpRoot + '.7.8', writable=False)
alarm8      = agent.Integer32(oidstr=snmpRoot + '.7.9', writable=False)
alarm9      = agent.Integer32(oidstr=snmpRoot + '.7.10', writable=False)
alarm10     = agent.Integer32(oidstr=snmpRoot + '.7.11', writable=False)
Uab1        = agent.Integer32(oidstr=snmpRoot + '.8.2.1', writable=False)
Uab2        = agent.Integer32(oidstr=snmpRoot + '.8.2.2', writable=False)
Uab3        = agent.Integer32(oidstr=snmpRoot + '.8.2.3', writable=False)
Uab4        = agent.Integer32(oidstr=snmpRoot + '.8.2.4', writable=False)
Uab5        = agent.Integer32(oidstr=snmpRoot + '.8.2.5', writable=False)
Bstatus     = agent.Integer32(oidstr=snmpRoot + '.8.3', writable=False)
rm48_1      = agent.Integer32(oidstr=snmpRoot + '.9.1.1', writable=False)
rm48_2      = agent.Integer32(oidstr=snmpRoot + '.9.2.1', writable=False)
rm48_3      = agent.Integer32(oidstr=snmpRoot + '.9.3.1', writable=False)
rm48_4      = agent.Integer32(oidstr=snmpRoot + '.9.4.1', writable=False)

"""
rc48 = agent.Table(
        oidstr = snmpRoot + '.9.2',
        indexes = [agent.Integer32()],
        columns = [
                (2, agent.DisplayString('column1')),
                (3, agent.DisplayString('column2')),
                (4, agent.DisplayString('column3')),
            ],
        counterobj = agent.Unsigned32(oidstr = snmpRoot + '.9.1')
    )

row1 = rc48.addRow([agent.Integer32(2)])
row2 = rc48.addRow([agent.Integer32(3)])
row3 = rc48.addRow([agent.Integer32(4)])
row4 = rc48.addRow([agent.Integer32(5)])
"""

try:
	agent.start()
except netsnmpagent.netsnmpAgentException as e:
	print("{0}".format(e))
	sys.exit(1)

while not stop:
    agent.check_and_process()

    mainParams = rcv.getMainParams()
    alarm.update(((mainParams[4] >> 7) & 1) if len(mainParams) > 4 else 0)
    version.update((mainParams[4] & 0x7f) if len(mainParams) > 4 else 0)
    rm48_1.update(((mainParams[5] >> 1) & 1) if len(mainParams) > 5 else 0)
    rm48_2.update(((mainParams[5] >> 2) & 1) if len(mainParams) > 5 else 0)
    rm48_3.update(((mainParams[5] >> 3) & 1) if len(mainParams) > 5 else 0)
    rm48_4.update(((mainParams[5] >> 4) & 1) if len(mainParams) > 5 else 0)
    subversion.update((mainParams[7]) if len(mainParams) > 7 else 0)
    UloadVar.update(int(round((mainParams[8] | (mainParams[9] << 8)) / 10.0)) if len(mainParams) > 9 else 0)
    UabVar.update((mainParams[10] | (mainParams[11] << 8)) if len(mainParams) > 11 else 0)
    U220Var.update((mainParams[12] | (mainParams[13] << 8)) if len(mainParams) > 13 else 0)
    IloadVar.update((mainParams[14] | (mainParams[15] << 8)) if len(mainParams) > 15 else 0)
    IabVar.update((mainParams[16] | (mainParams[17] << 8)) if len(mainParams) > 17 else 0)
    PVar.update((mainParams[18] | (mainParams[19] << 8)) if len(mainParams) > 19 else 0)
    TVar.update((mainParams[20] | (mainParams[21] << 8)) if len(mainParams) > 21 else 0)
    x = mainParams[22] if len(mainParams) > 22 else 0
    sensor1.update((x >> 0) & 1)
    sensor2.update((x >> 1) & 1)
    sensor3.update((x >> 2) & 1)
    sensor4.update((x >> 3) & 1)
    x = mainParams[24] if len(mainParams) > 24 else 0
    auto1.update((x >> 1) & 1)
    auto2.update((x >> 2) & 1)
    auto3.update((x >> 3) & 1)
    auto4.update((x >> 4) & 1)
    auto5.update((x >> 5) & 1)
    auto6.update((x >> 6) & 1)
    x = mainParams[26] if len(mainParams) > 26 else 0
    alarm0.update((x >> 0) & 1)
    alarm1.update((x >> 1) & 1)
    alarm2.update((x >> 2) & 1)
    alarm3.update((x >> 3) & 1)
    alarm4.update((x >> 4) & 1)
    alarm5.update((x >> 5) & 1)
    alarm6.update((x >> 6) & 1)
    alarm7.update((x >> 7) & 1)
    x = mainParams[27] if len(mainParams) > 27 else 0
    alarm8.update((x >> 0) & 1)
    alarm9.update((x >> 1) & 1)
    alarm10.update((x >> 2) & 1)
    x = mainParams[35] if len(mainParams) > 35 else 0
    discharge.update((x >> 7) & 1)

    abParams = rcv.getAbParams()
    Uab1.update(abParams[3] if len(abParams) > 3 else 0)
    Uab2.update(abParams[4] if len(abParams) > 4 else 0)
    Uab3.update(abParams[5] if len(abParams) > 5 else 0)
    Uab4.update(abParams[6] if len(abParams) > 6 else 0)
    Uab5.update(abParams[7] if len(abParams) > 7 else 0)
    Bstatus.update(abParams[8] if len(abParams) > 8 else 0)

agent.shutdown()
